#Generate structures from Smooth Scan output.

def ConvNum2Elem(s):
    Element=['H','He','Li','Be','B','C','N','O','F','Ne','Na','Mg','Al','Si','P','S','Cl','Ar','K','Ca','Sc','Ti','V','Cr','Mn','Fe','Co','Ni','Cu','Zn','Ga','Ge','As','Se','Br','Kr','Rb','Sr','Y','Zr','Nb','Mo','Tc','Ru','Rh','Pd','Ag','Cd','In','Sn','Sb','Te','I','Xe','Cs','Ba','La','Ce','Pr','Nd','Pm','Sm','Eu','Gd','Tb','Dy','Ho','Er','Tm','Yb','Lu','Hf','Ta','W','Re','Os','Ir','Pt','Au','Hg','Tl','Pb','Bi','Po','At','Rn','Fr','Ra','Ac','Th','Pa','U','Np','Pu','Am','Cm','Bk','Cf','Es','Fm','Md','No','Lr','Rf','Db','Sg','Bh','Hs','Mt'] 
    return Element[int(s)-1]
def is_number(s):
    try:
        float(s)
        return True
    except ValueError:
        pass
    try:
        import unicodedata
        unicodedata.numeric(s)
        return True
    except (TypeError, ValueError):
        pass
    return False

import sys
filename=sys.argv[1]

#Read informations.
Charge = 0
Multiplicity = 1
f = open(filename,'r')
for l in f.readlines():
    L = l.split()
    if len(L)==6 and L[0]=='Charge' and L[3]=='Multiplicity':
        Charge=int(L[2])
        Multiplicity=int(L[5])
        break

#Create .gjf file for scan points.
flag1 = False
flag2 = False
f = open(filename,'r')
i = 1
for l in f.readlines():
    L = l.split()
    if len(L)==2 and L[0]=='Standard' and L[1]=='orientation:':
        flag1 = True
        Geomfile = 'Geom' + str(i) + '.gjf'
        file = open(Geomfile,'w')
        file.write('%nprocshared=28\n')
        file.write('#p M062X/def2SVP em=GD3 SCRF(solvent=Acetonitrile) opt=modredundant\n\n')
        file.write('tilte\n\n')
        file.write(str(Charge)+' '+str(Multiplicity)+'\n')
    if flag1 and len(L)==6 and L[0]=='1':
        flag1 = False
        flag2 = True
    if flag2:
        if len(L)==6 and is_number(L[0]):
            file = open(Geomfile,'a')
            file.write(ConvNum2Elem(L[1])+' '+L[3]+' '+L[4]+' '+L[5]+'\n')
        elif len(L)!=6:
            flag2 = False
            file = open(Geomfile,'a')
            file.write('\n\n')
    if len(L)==2 and L[0]=='Optimization' and L[1]=='completed.':
        i = i + 1
    elif len(L)>2 and L[0]=='Optimization' and L[1]=='completed':
        i = i + 1
